# download and extract azcopy
write-host "... download & extract azcopy"
Invoke-WebRequest -URI https://aka.ms/downloadazcopy-v10-windows -Outfile azcopy.zip
Expand-Archive -Path azcopy.zip -Force

if ((Test-Path ".\azcopy" -PathType Container)) {
        $azcopypath = (Get-Childitem Path .\azcopy\  -Include *azcopy.exe* -File -Recurse -ErrorAction SilentlyContinue) 
    } else {
        write-host "... download failed"
        exit 1
}


# prepare foldername
$folder = (Get-Date -Format "yyyy-MM-dd") + '_' + ($env:computername)
# write-host $folder

# create folder
if (!(Test-Path $folder -PathType Container)) {
    write-host "... create folder " $folder
    New-Item $folder -ItemType Directory | Out-Null
}

# create files in folder
if ((Test-Path $folder -PathType Container)) { 
    write-host "... create testfile"   
    #fsutil file createnew .\$folder\1kb-testfile.txt 1024
    #fsutil file createnew .\$folder\10mb-testfile.txt 10485760
    fsutil file createnew .\$folder\50mb-testfile.txt 52428800 | Out-Null
    #fsutil file createnew .\$folder\100mb-testfile.txt 104857600
    #fsutil file createnew .\$folder\500mb-testfile.txt 524288000
    #fsutil file createnew .\$folder\1gb-testfile.txt 1048576000
}

### get needed systemsettings
 write-host "... collect systemsettings"

# hostname
'########## hostname ############# ' | out-file -Force .\$folder\systemsettings.txt 
$env:computername | out-file -Force .\$folder\systemsettings.txt -Append
' ' | out-file -Force .\$folder\systemsettings.txt  -Append

# system-wide proxy 
'########## system-wide proxy ############# ' | out-file -Force .\$folder\systemsettings.txt -Append
netsh winhttp show proxy | out-file -Force .\$folder\systemsettings.txt -Append

# user-specific proxy
'########## user-specific proxy ############# ' | out-file -Force .\$folder\systemsettings.txt -Append
Get-ItemProperty -Path "Registry::HKCU\Software\Microsoft\Windows\CurrentVersion\Internet Settings" | out-file -Force .\$folder\systemsettings.txt -Append

# internal ip
'########## internal ips ############# ' | out-file -Force .\$folder\systemsettings.txt -Append
ipconfig | out-file -Force .\$folder\systemsettings.txt -Append

# public ip
'########## public ip ############# ' | out-file -Force .\$folder\systemsettings.txt -Append
$publicIP = (Invoke-WebRequest -uri "https://api.ipify.org/").Content 
$publicIP | out-file -Force .\$folder\systemsettings.txt -Append

 
# upload test
write-host "... transfer test-data to azure blob storage"
& $azcopypath copy $folder 'https://kundenuploadtest.blob.core.windows.net/upload?si=testuploadberechtigung&spr=https&sv=2022-11-02&sr=c&sig=xxxxxxxxx' --recursive


read-host Press ENTER to finish ...